#ifndef PARSER_ATP_SST_DATA_H
#define PARSER_ATP_SST_DATA_H
/*
   *  Object          : parser_atp_sst_data.h
   *  State           :  %state%
   *  Creation date   :  Apr  7  2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief this file containes the definitions for the HOST-SEP protocl.
   *         
   *
   *  \version parser_atp_sst_data.h#1:csrc:3
   *  \author TaniaM
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/

/************************ Includes *****************************/
#include "msg_defs.h"
#include "SST_SEP_TST.h"
/************************ Defines ******************************/


/* BasicDataOp offsets of the parameters in the message (in words) */
typedef enum
{
	BASIC_DATA_PASS_SIZE_OFFSET  = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 0),
	BASIC_DATA_MAX_TRAILS_OFFSET = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 1),
	BASIC_DATA_DATA_SIZE_OFFSET  = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 2),            
	BASIC_DATA_READ_OFFSET       = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 3),
	BASIC_DATA_WRITE_SIZE_OFFSET = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 4),
	BASIC_DATA_WRITE_OFFSET      = (DX_SEP_HOST_SEP_BASE_MSG_OFFSET + 5)

}BasicDataOp_Parameters_Offsets;

DxUint32_t DX_SEP_SST_PARSER_BasicDataOp(DxUint32_t* msg);
DxUint32_t DX_SEP_SST_PARSER_BindingWritingPermissions(DxUint32_t* msg);
/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_BasicUnAuthnticatedDataOp
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* 
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. end SEP message and return
******************************************************************************/ 
DxUint32_t DX_SEP_SST_PARSER_BasicUnAuthnticatedDataOp(DxUint32_t* msg);
/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_SST_PARSER_DataReplace      
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return                                     
*
* 
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_SST_PARSER_DataReplace(DxUint32_t* msg);

/*****************************************************************************
* Function Name:
*  DX_SEP_SST_PARSER_ReadOnlyData
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* 
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. extract parameters from the message 
* 3. call QA SEP function
* 4. end SEP message and return
******************************************************************************/ 

DxUint32_t DX_SEP_SST_PARSER_ReadOnlyData(DxUint32_t* msg);
#endif
